{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 05.10.98 - 18:50:53 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,
  WinProcs,
{$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  MMDesign,
  MMSpGram,
  MMObj,
  MMDSPObj,
  MMWavIn,
  MMConect,
  MMDIBCv,
  MMSwitch,
  MMLEDS,
  MMSpectr,
  MMLevel,
  MMHTimer,
  MMOscope,
  MMHook;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    MMSpectrogram1: TMMSpectrogram;
    Label1: TLabel;
    Label24: TLabel;
    MMLED1: TMMLED;
    Label27: TLabel;
    MMLED2: TMMLED;
    Label28: TLabel;
    MMLED3: TMMLED;
    Label37: TLabel;
    MMLED4: TMMLED;
    Label38: TLabel;
    btnStop: TButton;
    btnStart: TButton;
    ckBEmbossed: TCheckBox;
    MMLEDSpin2: TMMLEDSpin;
    MMLEDSpin3: TMMLEDSpin;
    ckBDrawScale: TCheckBox;
    ckBLogAmp: TCheckBox;
    ckBFrames: TCheckBox;
    MMConnector1: TMMConnector;
    MMWaveIn1: TMMWaveIn;
    Timer1: TTimer;
    Label10: TLabel;
    MMSwitch1: TMMSwitch;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label20: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label2: TLabel;
    ckBAccel: TCheckBox;
    MMSpectrum1: TMMSpectrum;
    MMOscope1: TMMOscope;
    ckBScroll: TCheckBox;
    MMDesigner1: TMMDesigner;
    MMLEDSpin4: TMMLEDSpin;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure ckBEmbossedClick(Sender: TObject);
    procedure MMLEDSpin2DownClick(Sender: TObject);
    procedure MMLEDSpin2UpClick(Sender: TObject);
    procedure MMLEDSpin3DownClick(Sender: TObject);
    procedure MMLEDSpin3UpClick(Sender: TObject);
    procedure ckBDrawScaleClick(Sender: TObject);
    procedure ckBLogAmpClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMSwitch1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MMSpectrogramGainOverflow(Sender: TObject);
    procedure MMSpectrogramPcmOverflow(Sender: TObject);
    procedure MMConnector1Trigger(Sender: TObject);
    procedure MMLEDSpin4Change(Sender: TObject);
    procedure ckBAccelClick(Sender: TObject);
    procedure ckBScrollClick(Sender: TObject);
  private
  public
    oldRefreshCount: Longint;
    OverFlow: Boolean;

    procedure SetUserPalette;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   Overflow := False;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Timer1.Enabled := False;
   MMWaveIn1.Close;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.btnStartClick(Sender: TObject);
begin
   MMWaveIn1.Start;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   MMWaveIn1.Close;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.ckBAccelClick(Sender: TObject);
begin
   MMSpectrogram1.Accelerate := ckBAccel.Checked;
   MMOscope1.Accelerate := ckBAccel.Checked;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.ckBEmbossedClick(Sender: TObject);
begin
   MMSpectrogram1.Embossed := ckBEmbossed.Checked;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.ckBDrawScaleClick(Sender: TObject);
begin
   MMSpectrogram1.DrawScale := ckBDrawScale.Checked;
   MMOscope1.DrawAmpScale := ckBDrawScale.Checked;
   MMOscope1.DrawTimeScale := ckBDrawScale.Checked;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.ckBLogAmpClick(Sender: TObject);
begin
   MMSpectrogram1.LogAmp := ckBLogAmp.Checked;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.ckBScrollClick(Sender: TObject);
begin
   if ckBScroll.Checked then
   begin
      MMSpectrogram1.Scroll := True;
      MMSpectrum1.Kind := skScroll;
      MMOscope1.Scroll := True;
      MMOscope1.Kind := okMirLines;
   end
   else
   begin
      MMSpectrogram1.Scroll := False;
      MMSpectrum1.Kind := skBars;
      MMOscope1.Scroll := False;
      MMOscope1.Kind := okDots;
   end;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMLEDSpin2UpClick(Sender: TObject);
begin
   MMOscope1.FFTLength := MMOscope1.FFTLength * 2;
   MMSpectrogram1.FFTLength := MMSpectrogram1.FFTLength * 2;
   MMLEDSpin2.Value := MMOscope1.FFTLength;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMLEDSpin2DownClick(Sender: TObject);
begin
   MMOscope1.FFTLength := MMOscope1.FFTLength div 2;
   MMSpectrogram1.FFTLength := MMSpectrogram1.FFTLength div 2;
   MMLEDSpin2.Value := MMOscope1.FFTLength;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMLEDSpin3UpClick(Sender: TObject);
var
   Factor: integer;
begin
   if (MMSpectrogram1.AmplitudeScale < 10) then Factor := 1
   else Factor := 10;

   MMSpectrogram1.AmplitudeScale := MMSpectrogram1.AmplitudeScale + Factor;
   MMLEDSpin3.Value := MMSpectrogram1.AmplitudeScale;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMLEDSpin3DownClick(Sender: TObject);
var
   Factor: integer;
begin
   if (MMSpectrogram1.AmplitudeScale > 10) then Factor := 10
   else Factor := 1;

   MMSpectrogram1.AmplitudeScale := MMSpectrogram1.AmplitudeScale - Factor;
   MMLEDSpin3.Value := MMSpectrogram1.AmplitudeScale;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.SetUserPalette;
type
   { Logical Palette }
   TLogPal = record
    palVersion: Word;
    palNumEntries: Word;
    palEntry: array[0..255] of TPaletteEntry;
  end;

var
   i,clr: Longint;
   LogPal: TLogPal;

begin
   FillChar(LogPal, sizeOf(LogPal),0);
   with LogPal do
   begin
      palVersion := $300;
      palNumEntries := 256;

      for i := MIN_COLOR to MIN_COLOR+NUM_COLORS-1 do
      begin
         clr := (i-MIN_COLOR)*256 div NUM_COLORS;

         if (clr < 128) then
         begin
            palEntry[i].peRed := clr shl 1;
            palEntry[i].peGreen := clr shl 1;
            palEntry[i].peBlue := clr shl 1;
         end
         else
         begin
            palEntry[i].peRed := 255;
            palEntry[i].peGreen := 255 - 2*(clr - 128);
            palEntry[i].peBlue := 255 -  2*(clr - 128);
         end;
      end;
   end;
   MMSpectrogram1.SetPalette(@LogPal);
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMSwitch1Change(Sender: TObject);
begin
   if MMSwitch1.Position < MMSwitch1.NumPositions-1 then
   begin
      MMSpectrogram1.PaletteTyp := TMMSpectrogramPalette(MMSwitch1.Position);
   end
   else SetUserPalette;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
var
   Temp: Longint;

begin
     if ckBFrames.Checked and (MMConnector1.RefreshCountSpectrogram <> OldRefreshCount) then
     begin
        Temp := MMConnector1.RefreshCountSpectrogram;
        ckBFrames.Caption := ' ' + IntToStr(Temp) + ' frames/s';
        OldRefreshCount := Temp;
     end;
     MMConnector1.RefreshCountSpectrogram := 0;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMSpectrogramGainOverflow(Sender: TObject);
begin
   Overflow := True;
   MMLED2.Enabled := True;
   MMLED4.Enabled := True;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMSpectrogramPcmOverflow(Sender: TObject);
begin
   Overflow := True;
   MMLED1.Enabled := True;
   MMLED3.Enabled := True;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMConnector1Trigger(Sender: TObject);
begin
   if Overflow then
   begin
      MMLED1.Enabled := False;
      MMLED2.Enabled := False;
      MMLED3.Enabled := False;
      MMLED4.Enabled := False;
      Overflow := False;
   end;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMLEDSpin4Change(Sender: TObject);
begin
   MMSpectrogram1.Sensitivy := MMLEDSpin4.Value;
end;

end.
